-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: localhost:3306
-- Tiempo de generación: 05-12-2025 a las 23:42:02
-- Versión del servidor: 8.0.30
-- Versión de PHP: 8.1.10

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `inventario_ti`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `areas`
--

CREATE TABLE `areas` (
  `id` int NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `estado` enum('Activo','Inactivo') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activo'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `areas`
--

INSERT INTO `areas` (`id`, `nombre`, `estado`) VALUES
(1, 'GERENCIA', 'Activo'),
(2, 'ADMINISTRACIÓN', 'Activo'),
(3, 'GESTIÓN HUMANA', 'Activo'),
(4, 'SISTEMAS', 'Activo'),
(5, 'LOGISTICA', 'Activo'),
(6, 'CONTABILIDAD', 'Activo'),
(7, 'PROYECTOS', 'Activo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignaciones`
--

CREATE TABLE `asignaciones` (
  `id` int NOT NULL,
  `id_equipo` int NOT NULL,
  `id_empleado` int NOT NULL,
  `fecha_entrega` datetime NOT NULL,
  `fecha_devolucion` datetime DEFAULT NULL,
  `estado_asignacion` enum('Activa','Finalizada') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activa',
  `observaciones_entrega` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `observaciones_devolucion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `acta_firmada_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `acta_devolucion_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `imagen_devolucion_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `imagen_devolucion_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `imagen_devolucion_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `asignaciones`
--

INSERT INTO `asignaciones` (`id`, `id_equipo`, `id_empleado`, `fecha_entrega`, `fecha_devolucion`, `estado_asignacion`, `observaciones_entrega`, `observaciones_devolucion`, `acta_firmada_path`, `acta_devolucion_path`, `imagen_devolucion_1`, `imagen_devolucion_2`, `imagen_devolucion_3`) VALUES
(1, 1, 1, '2025-11-08 06:59:52', '2025-11-09 07:48:00', 'Finalizada', 'asignacion 1', 'Estado al recibir: Bueno.\nObservaciones: ', 'acta_1_1762670869.pdf', 'acta_devolucion_1_1762752935.pdf', '1762674646_2025-05-20_21h08_48.png', '1762674646_2025-05-20_21h16_13.png', '1762674646_2025-05-20_21h34_39.png'),
(2, 2, 1, '2025-11-09 07:15:25', NULL, 'Activa', 'otro', NULL, NULL, NULL, NULL, NULL, NULL),
(3, 4, 2, '2025-11-22 22:55:56', NULL, 'Activa', 'NUEVO EMPLEADO', NULL, 'acta_3_1763852445.pdf', NULL, NULL, NULL, NULL),
(4, 3, 1, '2025-12-01 17:55:57', '2025-12-02 20:44:00', 'Finalizada', '', 'Estado al recibir: Regular (con detalles).\nObservaciones: equipo con rayones', NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `bajas`
--

CREATE TABLE `bajas` (
  `id` int NOT NULL,
  `id_equipo` int NOT NULL,
  `fecha_baja` date NOT NULL,
  `motivo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `observaciones` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `acta_baja_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `descripcion_motivo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `id_usuario_responsable` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `bajas`
--

INSERT INTO `bajas` (`id`, `id_equipo`, `fecha_baja`, `motivo`, `observaciones`, `acta_baja_path`, `descripcion_motivo`, `id_usuario_responsable`) VALUES
(1, 1, '2025-11-12', 'Dañado sin reparación', 'no funciona', 'acta_baja_1_1762928227.pdf', NULL, NULL),
(2, 5, '2025-12-02', 'Obsoleto', '', NULL, NULL, NULL),
(3, 5, '2025-12-02', 'Obsoleto', '', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cargos`
--

CREATE TABLE `cargos` (
  `id` int NOT NULL,
  `id_area` int NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `estado` enum('Activo','Inactivo') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activo'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `cargos`
--

INSERT INTO `cargos` (`id`, `id_area`, `nombre`, `estado`) VALUES
(1, 1, 'GERENTE DE SUCURSAL', 'Activo'),
(2, 2, 'JEFE ADMINISTRATIVO', 'Activo'),
(3, 2, 'ASISTENTE ADMINISTRATIVO', 'Activo'),
(4, 3, 'JEFE DE RR.HH.', 'Activo'),
(5, 5, 'JEFE DE LOGISTICA', 'Activo'),
(6, 5, 'AUXILIAR DE ALMACEN', 'Activo'),
(7, 4, 'JEFE DE TI', 'Activo'),
(8, 4, 'ASISTENTE DE TI', 'Activo'),
(9, 4, 'Asistente de Sistemas', 'Activo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `configuracion`
--

CREATE TABLE `configuracion` (
  `id` int NOT NULL,
  `clave` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `valor` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `configuracion`
--

INSERT INTO `configuracion` (`id`, `clave`, `valor`) VALUES
(1, 'moneda_simbolo', 'S/');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `empleados`
--

CREATE TABLE `empleados` (
  `id` int NOT NULL,
  `id_sucursal` int NOT NULL,
  `dni` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `nombres` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `apellidos` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_cargo` int DEFAULT NULL,
  `id_area` int DEFAULT NULL,
  `estado` enum('Activo','Inactivo') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activo'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `empleados`
--

INSERT INTO `empleados` (`id`, `id_sucursal`, `dni`, `nombres`, `apellidos`, `id_cargo`, `id_area`, `estado`) VALUES
(1, 1, '41414141', 'CARLOS', 'RAMIREZ', 2, 2, 'Activo'),
(2, 1, '40404040', 'VICTOR', 'RAMOS', 2, 2, 'Activo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `equipos`
--

CREATE TABLE `equipos` (
  `id` int NOT NULL,
  `id_sucursal` int NOT NULL,
  `codigo_inventario` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_tipo_equipo` int NOT NULL,
  `id_marca` int NOT NULL,
  `id_modelo` int NOT NULL,
  `numero_serie` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `caracteristicas` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `tipo_adquisicion` enum('Propio','Arrendado','Prestamo') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `fecha_adquisicion` date DEFAULT NULL,
  `proveedor` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `estado` enum('Disponible','Asignado','En Reparacion','De Baja') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Disponible',
  `observaciones` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `fecha_registro` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `equipos`
--

INSERT INTO `equipos` (`id`, `id_sucursal`, `codigo_inventario`, `id_tipo_equipo`, `id_marca`, `id_modelo`, `numero_serie`, `caracteristicas`, `tipo_adquisicion`, `fecha_adquisicion`, `proveedor`, `estado`, `observaciones`, `fecha_registro`) VALUES
(1, 1, 'INVENTARIO2025- 001', 2, 1, 1, 'SERIE-001', 'PROCESADOR CORE I5 / RAM 16GB / SSD', 'Propio', '2025-11-07', 'PROVEEDOR 1', 'De Baja', 'EQUIPO NUEVO PARA EL GERENTE SUCURSAL 1', '2025-11-08 04:07:35'),
(2, 1, 'INVENTARIO2025- 002', 1, 2, 3, 'SERIE-002', 'PROCESADOR CORE I5 / RAM 16GB /SSD', 'Arrendado', '2025-11-08', 'PROVEEDOR 2', 'Asignado', 'PARA BACKUP', '2025-11-08 22:36:50'),
(3, 1, 'INVENTARIO2025- 003', 2, 3, 4, 'SERIE-003', '', 'Propio', '2025-11-19', 'PROVEEDOR 2', 'Disponible', '', '2025-11-19 16:24:03'),
(4, 1, 'INVENTARIO2025- 004', 2, 4, 5, 'SERIE-004', 'PROCESADOR CORE I5 / RAM 16GB / SSD', 'Propio', '2025-11-21', 'PROVEEDOR 2', 'Disponible', 'EQUIPO PARA EL JEFE DE ADMINISTRACIÓN', '2025-11-22 22:48:00'),
(5, 1, 'ooohhhjjjk', 3, 3, 4, 'ESTSIS01', 'I7 LAPTOPS ', 'Propio', '2025-12-01', 'INCOEP ', 'De Baja', 'EQUIPO EN PERFECTAS CONDICIONES', '2025-12-01 17:53:45'),
(6, 3, 'MOBSIS01', 5, 2, 3, '22590', 'brother mfc t4500dw', 'Arrendado', '2025-12-11', 'incoep group', 'En Reparacion', 'equipo operatio', '2025-12-02 18:23:29');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `marcas`
--

CREATE TABLE `marcas` (
  `id` int NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `estado` enum('Activo','Inactivo') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activo'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `marcas`
--

INSERT INTO `marcas` (`id`, `nombre`, `estado`) VALUES
(1, 'LENOVO', 'Activo'),
(2, 'HP', 'Activo'),
(3, 'ASUS', 'Activo'),
(4, 'DELL', 'Activo'),
(5, 'FORZA', 'Activo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `modelos`
--

CREATE TABLE `modelos` (
  `id` int NOT NULL,
  `id_marca` int NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `estado` enum('Activo','Inactivo') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activo'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `modelos`
--

INSERT INTO `modelos` (`id`, `id_marca`, `nombre`, `estado`) VALUES
(1, 1, 'LENOVO A-2025', 'Activo'),
(2, 1, 'LENOVO-A1', 'Activo'),
(3, 2, 'HP-V2025', 'Activo'),
(4, 3, 'ASUS-2025', 'Activo'),
(5, 4, 'DELL-2025', 'Activo'),
(6, 5, 'PSU100VA', 'Activo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `reparaciones`
--

CREATE TABLE `reparaciones` (
  `id` int NOT NULL,
  `id_equipo` int NOT NULL,
  `fecha_ingreso` date NOT NULL,
  `fecha_salida` date DEFAULT NULL,
  `motivo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `proveedor_servicio` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `costo` decimal(10,2) DEFAULT '0.00',
  `observaciones_salida` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `estado_reparacion` enum('En Proceso','Finalizada') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'En Proceso',
  `prioridad` enum('Baja','Media','Alta') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Media',
  `estado_anterior_equipo` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `id_tecnico` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `reparaciones`
--

INSERT INTO `reparaciones` (`id`, `id_equipo`, `fecha_ingreso`, `fecha_salida`, `motivo`, `proveedor_servicio`, `costo`, `observaciones_salida`, `estado_reparacion`, `prioridad`, `estado_anterior_equipo`, `id_tecnico`) VALUES
(1, 3, '2025-10-01', '2025-10-01', 'no enciende', 'PROVEEDOR 1', 100.00, 'solucionado', 'Finalizada', 'Media', NULL, NULL),
(2, 5, '2025-10-22', '2025-10-22', 'MANTENIMIENTO PREVENTIVO', 'PROVEEDOR 2', 30.00, 'MANTENIMIENTO CORRECTIVO REALIZADO', 'Finalizada', 'Media', NULL, NULL),
(3, 1, '2025-11-10', '2025-11-10', 'Se envía para mantenimiento correctivo', 'PROVEEDOR 1', 50.00, 'Se realizó el mantenimiento correctivo al equipo computador', 'Finalizada', 'Media', NULL, NULL),
(4, 1, '2025-11-10', '2025-11-12', 'repotenciación', 'PROVEEDOR 1', 100.00, 'terminado', 'Finalizada', 'Media', NULL, NULL),
(5, 6, '2025-12-02', '2025-12-02', 'Se atasca la hoja', 'LANDER VILCA ', 100.00, 'MANTENIMIENTO CORRECTIVO', 'Finalizada', 'Media', NULL, NULL),
(6, 6, '2025-12-02', '2025-12-05', 'No enciende', 'JIMMY', 100.00, 'ok', 'Finalizada', 'Media', NULL, NULL),
(7, 6, '2025-12-05', NULL, 'prueba', 'jimmy minchola', 0.00, NULL, 'En Proceso', 'Media', NULL, 2),
(8, 4, '2025-12-05', '2025-12-05', 'Ingreso automático por cambio de estado a En Reparación desde la ficha del equipo.', NULL, 100.00, 'ok', 'Finalizada', 'Media', NULL, NULL),
(9, 4, '2025-12-05', '2025-12-05', 'MANTENIMIENTO', NULL, 100.00, 'MANTENIMIENTO CORRECTIVO', 'Finalizada', 'Media', NULL, NULL),
(10, 2, '2025-12-05', '2025-12-05', 'EQUIPO POR MANTENIMEINTO', NULL, 20.00, 'MANTENIMIENTO', 'Finalizada', 'Alta', 'Asignado', NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `reparacion_comentarios`
--

CREATE TABLE `reparacion_comentarios` (
  `id` int NOT NULL,
  `id_reparacion` int NOT NULL,
  `id_usuario` int NOT NULL,
  `comentario` text COLLATE utf8mb4_general_ci NOT NULL,
  `fecha_comentario` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `reparacion_comentarios`
--

INSERT INTO `reparacion_comentarios` (`id`, `id_reparacion`, `id_usuario`, `comentario`, `fecha_comentario`) VALUES
(1, 6, 1, 'se procedio a realizar mantenimiento del equipo', '2025-12-02 23:20:36'),
(2, 6, 2, 'se verifico el equipo y no se encontro fallas', '2025-12-02 23:21:40');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `roles`
--

CREATE TABLE `roles` (
  `id` int NOT NULL,
  `nombre_rol` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `roles`
--

INSERT INTO `roles` (`id`, `nombre_rol`) VALUES
(1, 'Administrador'),
(2, 'Usuario');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `sucursales`
--

CREATE TABLE `sucursales` (
  `id` int NOT NULL,
  `nombre` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `telefono` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `estado` enum('Activo','Inactivo') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activo'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `sucursales`
--

INSERT INTO `sucursales` (`id`, `nombre`, `direccion`, `telefono`, `estado`) VALUES
(1, 'SUCURSAL #1', '', NULL, 'Activo'),
(2, 'SUCURSAL #2', '', NULL, 'Activo'),
(3, 'OBRA CAFFO', 'CAMPIÑA - MOCHE', NULL, 'Activo'),
(4, 'GARDEN', 'Calle los Claveles 117, URB. California', NULL, 'Activo'),
(6, 'PRATA', 'UNT CANAL DE VENTAS', NULL, 'Activo'),
(7, 'OFICINA ADMINISTRATIVA', 'Av.America sur 2140', NULL, 'Activo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tecnicos`
--

CREATE TABLE `tecnicos` (
  `id` int NOT NULL,
  `nombre` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `apellido` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `telefono` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `estado` enum('Activo','Inactivo') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activo',
  `fecha_creacion` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `tecnicos`
--

INSERT INTO `tecnicos` (`id`, `nombre`, `apellido`, `telefono`, `email`, `estado`, `fecha_creacion`) VALUES
(1, 'Lander', 'Vilca', NULL, 'lvilca@incoepgroup.com', 'Activo', '2025-12-05 23:11:38'),
(2, 'Jimmy', 'Minchola', NULL, 'jminchola@incoepgroup.com', 'Activo', '2025-12-05 23:13:39');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipos_equipo`
--

CREATE TABLE `tipos_equipo` (
  `id` int NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `estado` enum('Activo','Inactivo') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Activo'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `tipos_equipo`
--

INSERT INTO `tipos_equipo` (`id`, `nombre`, `estado`) VALUES
(1, 'DESKTOP', 'Activo'),
(2, 'NOTEBOOK', 'Activo'),
(3, 'LAPTOP', 'Activo'),
(4, 'IMPRESORAS MATRICIALES', 'Activo'),
(5, 'IMPRESORA A TINTA', 'Activo'),
(6, 'IMPRESORAS LASER', 'Activo'),
(7, 'IMPRESORAS MULTIFUNCIONALES', 'Activo'),
(8, 'ALL IN ONE', 'Activo'),
(9, 'TOUCH', 'Activo'),
(10, 'ESTABILIZADOR', 'Activo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int NOT NULL,
  `id_sucursal` int DEFAULT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `fecha_creacion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id`, `id_sucursal`, `nombre`, `email`, `password`, `activo`, `fecha_creacion`) VALUES
(1, NULL, 'Lander Vilca', 'admin@correo.com', '$2y$10$ytxlSlggxIB6D4dWwIRzfOGj8OMmce99QnPVbdhwjEyq6RcKiehy6', 1, '2025-08-03 06:56:20'),
(2, NULL, 'Jimmy Minchola', 'jminchola@incoepgroup.com', '$2y$10$I8TjeOmlOewah1Yo/UCQJeciO5T7UpAwusIXc9PhMVWCwFVhjofiW', 1, '2025-11-25 17:27:35');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuario_roles`
--

CREATE TABLE `usuario_roles` (
  `id_usuario` int NOT NULL,
  `id_rol` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `usuario_roles`
--

INSERT INTO `usuario_roles` (`id_usuario`, `id_rol`) VALUES
(1, 1),
(2, 2);

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `areas`
--
ALTER TABLE `areas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nombre` (`nombre`);

--
-- Indices de la tabla `asignaciones`
--
ALTER TABLE `asignaciones`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_equipo_asignado` (`id_equipo`),
  ADD KEY `fk_empleado_asignado` (`id_empleado`);

--
-- Indices de la tabla `bajas`
--
ALTER TABLE `bajas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_equipo_baja` (`id_equipo`);

--
-- Indices de la tabla `cargos`
--
ALTER TABLE `cargos`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nombre` (`nombre`),
  ADD KEY `fk_cargo_area` (`id_area`);

--
-- Indices de la tabla `configuracion`
--
ALTER TABLE `configuracion`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `clave_unica` (`clave`);

--
-- Indices de la tabla `empleados`
--
ALTER TABLE `empleados`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `dni` (`dni`),
  ADD KEY `fk_empleado_cargo` (`id_cargo`),
  ADD KEY `fk_empleado_area` (`id_area`),
  ADD KEY `fk_empleado_sucursal` (`id_sucursal`);

--
-- Indices de la tabla `equipos`
--
ALTER TABLE `equipos`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `codigo_inventario` (`codigo_inventario`),
  ADD UNIQUE KEY `numero_serie` (`numero_serie`),
  ADD KEY `fk_equipo_tipo` (`id_tipo_equipo`),
  ADD KEY `fk_equipo_marca` (`id_marca`),
  ADD KEY `fk_equipo_modelo` (`id_modelo`),
  ADD KEY `fk_equipo_sucursal` (`id_sucursal`);

--
-- Indices de la tabla `marcas`
--
ALTER TABLE `marcas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nombre` (`nombre`);

--
-- Indices de la tabla `modelos`
--
ALTER TABLE `modelos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_modelo_marca` (`id_marca`);

--
-- Indices de la tabla `reparaciones`
--
ALTER TABLE `reparaciones`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id_equipo` (`id_equipo`);

--
-- Indices de la tabla `reparacion_comentarios`
--
ALTER TABLE `reparacion_comentarios`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id_reparacion` (`id_reparacion`);

--
-- Indices de la tabla `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nombre_rol` (`nombre_rol`);

--
-- Indices de la tabla `sucursales`
--
ALTER TABLE `sucursales`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nombre` (`nombre`);

--
-- Indices de la tabla `tecnicos`
--
ALTER TABLE `tecnicos`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- Indices de la tabla `tipos_equipo`
--
ALTER TABLE `tipos_equipo`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nombre` (`nombre`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `fk_usuario_sucursal` (`id_sucursal`);

--
-- Indices de la tabla `usuario_roles`
--
ALTER TABLE `usuario_roles`
  ADD PRIMARY KEY (`id_usuario`,`id_rol`),
  ADD KEY `fk_rol` (`id_rol`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `areas`
--
ALTER TABLE `areas`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT de la tabla `asignaciones`
--
ALTER TABLE `asignaciones`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de la tabla `bajas`
--
ALTER TABLE `bajas`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de la tabla `cargos`
--
ALTER TABLE `cargos`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT de la tabla `configuracion`
--
ALTER TABLE `configuracion`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `empleados`
--
ALTER TABLE `empleados`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `equipos`
--
ALTER TABLE `equipos`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT de la tabla `marcas`
--
ALTER TABLE `marcas`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT de la tabla `modelos`
--
ALTER TABLE `modelos`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT de la tabla `reparaciones`
--
ALTER TABLE `reparaciones`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT de la tabla `reparacion_comentarios`
--
ALTER TABLE `reparacion_comentarios`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `roles`
--
ALTER TABLE `roles`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `sucursales`
--
ALTER TABLE `sucursales`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT de la tabla `tecnicos`
--
ALTER TABLE `tecnicos`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `tipos_equipo`
--
ALTER TABLE `tipos_equipo`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `asignaciones`
--
ALTER TABLE `asignaciones`
  ADD CONSTRAINT `fk_empleado_asignado` FOREIGN KEY (`id_empleado`) REFERENCES `empleados` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_equipo_asignado` FOREIGN KEY (`id_equipo`) REFERENCES `equipos` (`id`) ON UPDATE CASCADE;

--
-- Filtros para la tabla `bajas`
--
ALTER TABLE `bajas`
  ADD CONSTRAINT `fk_equipo_baja` FOREIGN KEY (`id_equipo`) REFERENCES `equipos` (`id`) ON UPDATE CASCADE;

--
-- Filtros para la tabla `cargos`
--
ALTER TABLE `cargos`
  ADD CONSTRAINT `fk_cargo_area` FOREIGN KEY (`id_area`) REFERENCES `areas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `empleados`
--
ALTER TABLE `empleados`
  ADD CONSTRAINT `fk_empleado_area` FOREIGN KEY (`id_area`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_empleado_cargo` FOREIGN KEY (`id_cargo`) REFERENCES `cargos` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_empleado_sucursal` FOREIGN KEY (`id_sucursal`) REFERENCES `sucursales` (`id`);

--
-- Filtros para la tabla `equipos`
--
ALTER TABLE `equipos`
  ADD CONSTRAINT `fk_equipo_marca` FOREIGN KEY (`id_marca`) REFERENCES `marcas` (`id`),
  ADD CONSTRAINT `fk_equipo_modelo` FOREIGN KEY (`id_modelo`) REFERENCES `modelos` (`id`),
  ADD CONSTRAINT `fk_equipo_sucursal` FOREIGN KEY (`id_sucursal`) REFERENCES `sucursales` (`id`),
  ADD CONSTRAINT `fk_equipo_tipo` FOREIGN KEY (`id_tipo_equipo`) REFERENCES `tipos_equipo` (`id`);

--
-- Filtros para la tabla `modelos`
--
ALTER TABLE `modelos`
  ADD CONSTRAINT `fk_modelo_marca` FOREIGN KEY (`id_marca`) REFERENCES `marcas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `reparaciones`
--
ALTER TABLE `reparaciones`
  ADD CONSTRAINT `reparaciones_ibfk_1` FOREIGN KEY (`id_equipo`) REFERENCES `equipos` (`id`);

--
-- Filtros para la tabla `reparacion_comentarios`
--
ALTER TABLE `reparacion_comentarios`
  ADD CONSTRAINT `reparacion_comentarios_ibfk_1` FOREIGN KEY (`id_reparacion`) REFERENCES `reparaciones` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD CONSTRAINT `fk_usuario_sucursal` FOREIGN KEY (`id_sucursal`) REFERENCES `sucursales` (`id`);

--
-- Filtros para la tabla `usuario_roles`
--
ALTER TABLE `usuario_roles`
  ADD CONSTRAINT `fk_rol` FOREIGN KEY (`id_rol`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_usuario` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
